""""
from reportlab.lib.pagesizes import A4
from reportlab.platypus import SimpleDocTemplate, Table, TableStyle, Paragraph, Spacer
from reportlab.lib import colors
from reportlab.lib.styles import getSampleStyleSheet
from reportlab.graphics.shapes import Drawing
from reportlab.graphics.charts.barcharts import VerticalBarChart

# PDF setup
doc = SimpleDocTemplate("report.pdf", pagesize=A4)
styles = getSampleStyleSheet()
elements = []

# Title
title = Paragraph("Monthly Sales Report", styles["Title"])
elements.append(title)
elements.append(Spacer(1, 20))

# Table
data = [["Product", "Qty", "Price", "Total"], ["Shoes", 10, 50, 500], ["Bags", 5, 80, 400]]
table = Table(data)
table.setStyle(TableStyle([
    ("BACKGROUND", (0,0), (-1,0), colors.grey),
    ("TEXTCOLOR", (0,0), (-1,0), colors.whitesmoke),
    ("ALIGN", (0,0), (-1,-1), "CENTER"),
    ("GRID", (0,0), (-1,-1), 1, colors.black)
]))
elements.append(table)
elements.append(Spacer(1, 40))

# Bar chart
drawing = Drawing(400, 200)
chart = VerticalBarChart()
chart.data = [[10,5]]
chart.categoryAxis.categoryNames = ['Shoes','Bags']
chart.valueAxis.valueMin = 0
chart.valueAxis.valueMax = 20
chart.valueAxis.valueStep = 5
drawing.add(chart)
elements.append(drawing)

# Build PDF
doc.build(elements)"""



from reportlab.lib.pagesizes import A4
from reportlab.platypus import SimpleDocTemplate, Table, TableStyle, Paragraph, Spacer, PageBreak
from reportlab.lib import colors
from reportlab.lib.styles import getSampleStyleSheet
from reportlab.graphics.shapes import Drawing
from reportlab.graphics.charts.barcharts import VerticalBarChart

def generate_report(datas, filename="report.pdf"):
    doc = SimpleDocTemplate(filename, pagesize=A4)
    styles = getSampleStyleSheet()
    elements = []

    # Title
    elements.append(Paragraph("Comprehensive Data Report", styles["Title"]))
    elements.append(Spacer(1, 20))

    # --- USERS DATA ---
    if "users_data" in datas:
        elements.append(Paragraph("Users Data", styles["Heading2"]))
        user_data = [["ID","Name","Password","Role","Preferences","Created At","Updated At"]]
        for u in datas["users_data"].get("data", []):
            user_data.append([
                u.get("id",""), u.get("identifier",""), u.get("password_hash",""),
                u.get("role",""), u.get("preferences",""), u.get("created_at",""), u.get("updated_at","")
            ])
        table = Table(user_data)
        table.setStyle(TableStyle([
            ("BACKGROUND",(0,0),(-1,0),colors.grey),
            ("TEXTCOLOR",(0,0),(-1,0),colors.whitesmoke),
            ("ALIGN",(0,0),(-1,-1),"CENTER"),
            ("GRID",(0,0),(-1,-1),1,colors.black),
        ]))
        elements.append(table)
        elements.append(Spacer(1, 20))

    # --- STATS API DATA ---
    if "stats_api" in datas:
        elements.append(Paragraph("Stats API Data", styles["Heading2"]))
        stats_data = [["ID","Name","Extra Data"]]
        for item in datas["stats_api"].get("data", []):
            extra = "\n".join(f"{k}: {v}" for k,v in item.get("data", {}).items()) or "No extra data"
            stats_data.append([item.get("id",""), item.get("name",""), extra])
        table = Table(stats_data)
        table.setStyle(TableStyle([
            ("BACKGROUND",(0,0),(-1,0),colors.grey),
            ("TEXTCOLOR",(0,0),(-1,0),colors.whitesmoke),
            ("ALIGN",(0,0),(-1,-1),"CENTER"),
            ("GRID",(0,0),(-1,-1),1,colors.black),
        ]))
        elements.append(table)
        elements.append(PageBreak())  # new page

    # --- USER PROFILES ---
    if "internal_data" in datas and "profile" in datas["internal_data"]:
        elements.append(Paragraph("User Profiles", styles["Heading2"]))
        profile_data = [["ID","User ID","Name","Display Name","Gender","Phone","Email","Created At","Updated At"]]
        for p in datas["internal_data"]["profile"].get("data", []):
            profile_data.append([
                p.get("id",""), p.get("user_id",""), p.get("name",""), p.get("display_name",""),
                p.get("gender",""), p.get("ph_number",""), p.get("email",""), p.get("created_at",""), p.get("updated_at","")
            ])
        table = Table(profile_data)
        table.setStyle(TableStyle([
            ("BACKGROUND",(0,0),(-1,0),colors.grey),
            ("TEXTCOLOR",(0,0),(-1,0),colors.whitesmoke),
            ("ALIGN",(0,0),(-1,-1),"CENTER"),
            ("GRID",(0,0),(-1,-1),1,colors.black),
        ]))
        elements.append(table)
        elements.append(Spacer(1, 20))

    # # --- SIMPLE CHART EXAMPLE ---
    # elements.append(Paragraph("Sample Bar Chart", styles["Heading2"]))
    # drawing = Drawing(400, 200)
    # chart = VerticalBarChart()
    # chart.data = [[len(datas.get("users_data", {}).get("data", [])),
    #                len(datas.get("stats_api", {}).get("data", []))]]
    # chart.categoryAxis.categoryNames = ["Users","Stats"]
    # chart.valueAxis.valueMin = 0
    # chart.valueAxis.valueMax = max(chart.data[0]) + 5
    # chart.valueAxis.valueStep = 1
    # drawing.add(chart)
    # elements.append(drawing)

    # Build PDF
    doc.build(elements)
    print(f"PDF report generated: {filename}")

# Example usage:
datas = {
    "users_data": {"data":[{"id":1,"identifier":"user1","password_hash":"xxx","role":"admin","preferences":"dark","created_at":"2025-09-20","updated_at":"2025-09-23"}]},
    "stats_api": {"data":[{"id":101,"name":"API Stat 1","data":{"reqs":150,"errors":5}}]},
    "internal_data": {"profile":{"data":[{"id":1,"user_id":1,"name":"John","display_name":"Johnny","gender":"M","ph_number":"123456","email":"john@example.com","created_at":"2025-09-20","updated_at":"2025-09-23"}]}}
}

generate_report(datas)

